//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Ilustrar el ejemplo 1
// Fecha:    X.15.12.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Caracteres Unicode
include unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Dimensiones de las cajas
real Anchura=8, Altura=1.2;

// Separación entre cajas
real Separacion=5;

// Tamaño y tipo del texto
pen TamTex=Helvetica(series="m",shape="n")+fontsize(1.5mm);

// La longitud de la flecha
real LongFlecha=4.2;

// Separación de los textos de la flecha
real SepFlecha=0.3;

// Grosor de las líneas
defaultpen(0.7);

// Cantidad inicial
draw(box((0,0),(Anchura,Altura)));
label("Cantidad inicial",(Anchura/2,Altura/2),TamTex);

// Punto medio de la primera parte
real Medio=Anchura+Separacion/2;

// Una flecha
draw((Medio-LongFlecha/2,Altura/2) -- (Medio+LongFlecha/2,Altura/2),
      0.25mm+black,Arrow(size=1.5mm));
label("+20\%",(Medio,Altura+SepFlecha),TamTex);

// Cantidad intermedia
draw(box((Anchura+Separacion,0),(2*Anchura+Separacion,Altura)));
label("Cantidad intermedia",(1.5*Anchura+Separacion,Altura/2),TamTex);

// Punto medio de la segunda parte
real Medio=2*Anchura+1.5*Separacion;

// Una flecha
draw((Medio-LongFlecha/2,Altura/2) -- (Medio+LongFlecha/2,Altura/2),
      0.25mm+black,Arrow(size=1.5mm));
label("$-$30\%",(Medio,Altura+SepFlecha),TamTex);

// Cantidad final
draw(box((2*Anchura+2*Separacion,0),(3*Anchura+2*Separacion,Altura)));
label("Cantidad final",(2.5*Anchura+2*Separacion,Altura/2),TamTex);

// La flecha global
draw((Anchura/2,-SepFlecha) -- (Anchura/2,-1.5) --
     (2.5*Anchura+2*Separacion,-1.5) -- (2.5*Anchura+2*Separacion,-SepFlecha),
      0.25mm+black,Arrow(size=1.5mm));
label("¿Variación global?",(1.5*Anchura+Separacion,-2.5),TamTex);
