#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  fracciones.py
# Objetivo: Da fracciones simplificables interesantes dado el denominador
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    X.29.9.2021
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

#------------------------------------------------
# Funciones
#------------------------------------------------

#------------------------------------------------
# Calcula el máximo común divisor de dos números
def mcd(a, b):
    while b: a, b = b, a % b
    return a

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos el denominador de la línea de órdenes
Denominador = int(sys.argv[1])

# Probamos todos los números de 1 a Denominador
for Numerador in range(1, Denominador):

    # Calculamos el máximo común divisor
    Maximo = mcd(Numerador, Denominador)

    # Para imprimir un resultado deben darse tres condiciones

    # Primera condición: la fracción se puede simplificar
    Condicion1 = Maximo>1

    # Segunda condición: la simplificación no es entre 10
    Condicion2 = Maximo%10

    if Condicion1 and Condicion2:
        # Calculamos la fracción simplificada
        NumeradorSimplificado = Numerador/Maximo
        DenominadorSimplificado = Denominador/Maximo

        # Tercera condición: el denominador simplificado tiene menos
        # de cuatro cifras
        if DenominadorSimplificado < 1000:

            # Imprimimos los datos
            print Numerador, '/', Denominador, '=',
            print NumeradorSimplificado, '/', DenominadorSimplificado, '=',
            print float(Numerador)/Denominador
