//---------------------------------------------------------------
// Fichero:  paso2.asy
// Objetivo: Representar el paso 2
// Fecha:    M.5.10.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Número de subdivisiones
int NumSub = 7;

// Desplazamiento para colocar la rejilla
real Desplazamiento = -NumSub/2;

// El mínimo valor de cada lado
int Min = -floor(NumSub/2);

// Rejilla de ayuda
add(shift(Desplazamiento,Desplazamiento)*grid(NumSub,NumSub,0.5bp+heavygray));

// Tipo de letra
pen Tipo=Helvetica(series="b",shape="n");

// El eje horizontal
for ( int i=Min ; i<-Min+1 ; ++i )
    { label(string(i), (i,0), Tipo+fontsize(18pt)); }

// El eje vertical
for ( int i=Min ; i<-Min+1 ; ++i )
    { label(string(i), (0,i), Tipo+fontsize(18pt)); }

// Las fracciones
for ( int i=Min ; i<-Min+1 ; ++i )
    {
    for ( int j=Min ; j<-Min+1 ; ++j )
        {
        if ( i*j != 0 )
            {
            string Texto = '$\\mathbf{\\frac{' + string(j) + '}{' +
                            string(i) + '}}$';
            label(Texto, (i,j), fontsize(16pt));
            }
        }
    }
