//---------------------------------------------------------------
// Fichero:  enunciado07.asy
// Objetivo: Representar el enunciado 7
// Fecha:    S.24.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve una etiqueta a partir de una cadena
Label Eti(string Texto)
    { return Label(Texto,fontsize(8pt)+blue); }

// Función que devuelve como cadena el valor en
// grados, minutos y segundos (redondeados) de un ángulo en grados
string GMS(real Ang)
    {
    int Gra = Floor(Ang);
    Ang = 60*(Ang - Gra);
    int Min = Floor(Ang);
    int Seg = round(60*(Ang - Min));
    string Respuesta = string(Gra)+"$^\circ$\,";
    Respuesta += string(Min)+"$^\prime$\,";
    Respuesta += string(Seg)+"$^{\prime\prime}$";
    return Respuesta;
    }

// Función que devuelve como etiqueta el valor de un ángulo
Label Ang(pair P1, pair V, pair P2, int e)
    { return Eti(GMS(degrees(P2-V)-degrees(P1-V)+360*e)); }

// Definición de los vértices
pair A=(4,-3), B=(5,0), C=(4,3), D=(-4,3), E=(-5,0), F=(-4,-3);

// Los ángulos
markangle("$\alpha$", radius=2mm, B, A, F, 0.5bp+blue);
markangle(Ang(C,B,A,0), radius=2mm, C, B, A, 0.5bp+blue);
markangle("$\alpha$", radius=2mm, D, C, B, 0.5bp+blue);
markangle("$\alpha$", radius=2mm, E, D, C, 0.5bp+blue);
markangle(Ang(F,E,D,1), radius=2mm, F, E, D, 0.5bp+blue);
markangle("$\alpha$", radius=2mm, A, F, E, 0.5bp+blue);

// El polígono
draw(A -- B -- C -- D -- E -- F -- cycle);
