#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  resta.py
# Objetivo: Da la resta de dos valores en el sistema sexagesimal
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    X.21.7.2021
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los números de la línea de órdenes
# Cada número tiene el formato h.m.s

# Minuendo
Min = sys.argv[1]

# Sustraendo
Sus = sys.argv[2]

# Descomponemos los números en sus partes
partesMin = Min.split('.')
partesSus = Sus.split('.')

# Los datos individuales
HorMin = int(partesMin[0])
MinMin = int(partesMin[1])
SegMin = int(partesMin[2])
HorSus = int(partesSus[0])
MinSus = int(partesSus[1])
SegSus = int(partesSus[2])

# Corregimos los minutos
if MinMin<MinSus:
    HorMin -= 1
    MinMin += 60

# Corregimos los segundos
if SegMin<SegSus:
    MinMin -= 1
    if MinMin < 0:
        HorMin -= 1
        MinMin += 60
    SegMin += 60

# Restamos
Hor = HorMin - HorSus
Min = MinMin - MinSus
Seg = SegMin - SegSus

# Imprimimos el resultado
print str(Hor) + '.' + str(Min) + '.' + str(Seg)
