#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  inventa2.py
# Objetivo: Inventar y resolver una colección de datos
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    M.19.4.2022
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para obtener números aleatorios
import random

#------------------------------------------------
# Variables que definen el ejercicio
#------------------------------------------------

# Número total de datos que hay que generar
Total = 25

# Posibles valores que se pueden tomar
Valores = [0, 1, 2, 3, 4, 5]

# Probabilidades de obtener cada valor
Probabilidades = [0.4, 0.2, 0.15, 0.1, 0.1, 0.05]

#------------------------------------------------
# El programa
#------------------------------------------------

# Para almacenar las frecuencias obtenidas
Frecuencia = {}
for Valor in Valores:
    Frecuencia[Valor] = 0

# Probabilidades acumuladas
Acumulada = []
for i,Probabilidad in enumerate(Probabilidades):
    Acumulada.append(sum(Probabilidades[:i]))

# Repetimos tantas veces como nos digan
for i in range(Total):

    # Obtenemos un número aleatorio entre 0 y 1
    Aleatorio = random.random()

    # Buscamos a qué valor corresponde
    Indice = 0
    for i,Probabilidad in enumerate(Acumulada):
        if Aleatorio>Probabilidad:
            Indice = i

    # Lo imprimimos y aumentamos su frecuencia
    print Valores[Indice],
    Frecuencia[Valores[Indice]] += 1

# Separamos
print

# Tabla de frecuencias
for Valor in Valores:
    print Valor, Frecuencia[Valor]
