//---------------------------------------------------------------
// Fichero:  solucion3.asy
// Objetivo: Representar la solución 3
// Fecha:    M.26.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.2cm,5.8cm);

// Grosor de las líneas
defaultpen(1);

// El formato de texto
pen Formato=black+fontsize(8pt);

// Los valores
string Valor[]={'0', '1', '2', '3', '4'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={5, 8, 2, 1, 6};
int MaxFre=max(Frecuencia);

// Grosor de las barras
real Grosor=0.9;

// Escalas para modificar las frecuencias
real EscalaY=0.8;
real EscalaX=1.5;

// Los ejes
draw((0,0)--(EscalaX*(TotalVal+.5),0));
draw((0,0)--(0,EscalaY*(MaxFre+.5)));

// El eje de ordenadas
for ( int i=1 ; i<=MaxFre ; ++i )
    {
    label(string(i), (0,EscalaY*i), 2*W, Formato);
    draw((-0.1,EscalaY*i)--(0.1,EscalaY*i));
    }

// El eje de absisas y las barras
for ( int i=0 ; i<TotalVal ; ++i )
    {
    real Abscisa=EscalaX*(i+1);
    label(Valor[i], (Abscisa,0), 1.5*S, Formato);
    draw((Abscisa,-0.05)--(Abscisa,0.05));
    draw(box((Abscisa-Grosor/2,0),(Abscisa+Grosor/2,EscalaY*Frecuencia[i])));
    }
