//---------------------------------------------------------------
// Fichero:  enunciado1.asy
// Objetivo: Representar el enunciado 1
// Fecha:    X.4.5.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// El formato de texto
pen Formato=black+fontsize(8pt);

// Los valores
string Valor[]={'A', 'B', 'C', 'D', 'E'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={38, 20, 44, 32, 46};
int MaxFre=max(Frecuencia);

// Grosor de las barras
real Grosor=0.75;

// Escala para modificar las frecuencias
real Escala=0.1;

// Los ejes
draw((0,0)--(TotalVal+.5,0));
draw((0,0)--(0,Escala*50.5));

// Líneas horizontales
for ( int i=10 ; i<=50 ; i+=10 )
    { draw((0.1,Escala*i)--(5.5,Escala*i),gray+0.75bp); }

// El eje de ordenadas
for ( int i=10 ; i<=50 ; i+=10 )
    {
    label(string(i), (0,Escala*i), 2*W, Formato);
    draw((-0.1,Escala*i)--(0.1,Escala*i));
    }

// El eje de absisas y las barras
for ( int i=0 ; i<TotalVal ; ++i )
    {
    filldraw(box((i+1-Grosor/2,Escala*Frecuencia[i]),
                 (i+1+Grosor/2,Escala*Frecuencia[i]+0.5)),white,white);
    label(string(Frecuencia[i]), (i+1,Escala*Frecuencia[i]), N,
          Helvetica(series="b",shape="n")+blue+fontsize(10pt));
    label(Valor[i], (i+1,0), 1.5*S, Formato);
    filldraw(box((i+1-Grosor/2,0),(i+1+Grosor/2,Escala*Frecuencia[i])),
                  mediumgreen,deepgreen);
    draw((i+1,-0.05)--(i+1,0.05));
    }
