//---------------------------------------------------------------
// Fichero:  solucion1.asy
// Objetivo: Representar la solución 1
// Fecha:    X.4.5.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Los valores
string Valor[]={'A', 'B', 'C', 'D', 'E'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={38, 20, 44, 32, 46};
int MaxFre=max(Frecuencia);

// La constante de proporcionalidad
real k=360/sum(Frecuencia);

// El círculo
draw(unitcircle);

// Los sectores
real Angulo=0;
for ( int i=0 ; i<TotalVal ; ++i )
    {
    real Avance=k*Frecuencia[i];
    draw((0,0)--dir(Angulo));
    draw((0,0)--dir(Angulo+Avance));
    label(Valor[i],0.6*dir(Angulo+Avance/2),fontsize(18pt));
    Angulo += Avance;
    }
