//---------------------------------------------------------------
// Fichero:  poligono.asy
// Objetivo: Representar un polígono de frecuencias
// Fecha:    S.23.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// Los valores
string Valor[]={'A', 'B', 'C', 'D'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={2, 4, 3, 5};
int MaxFre=max(Frecuencia);

// Los ejes
draw((0,0)--(TotalVal+.5,0));
draw((0,0)--(0,MaxFre+.5));

// El eje de ordenadas
for ( int i=1 ; i<=MaxFre ; ++i )
    {
    label(string(i), (0,i), W);
    draw((-0.1,i)--(0.1,i));
    }

// El eje de absisas y el camino del polígono
path Camino;
for ( int i=0 ; i<TotalVal ; ++i )
    {
    label(Valor[i], (i+1,0), S);
    draw((i+1,-0.05)--(i+1,0.05));
    dot((i+1,Frecuencia[i]),3bp+black);
    Camino=Camino--(i+1,Frecuencia[i]);
    }
draw(Camino);
