//---------------------------------------------------------------
// Fichero:  paso1.asy
// Objetivo: Representar el paso 1
// Fecha:    M.26.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm,4.5cm);

// Grosor de las líneas
defaultpen(1);

// El formato de texto
pen Formato=white+fontsize(8pt);

// Los valores
string Valor[]={'0', '1', '2', '3', '4', '5', '6'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={7, 4, 8, 3, 5, 9, 1};
int MaxFre=max(Frecuencia);

// Escala para modificar las frecuencias
real Escala=0.6;

// Los ejes
draw((0,0)--(TotalVal+.5,0));
draw((0,0)--(0,Escala*(MaxFre+.5)));

// El eje de ordenadas
for ( int i=1 ; i<=MaxFre ; ++i )
    { label(string(i), (0,Escala*i), 2*W, Formato); }

// El eje de absisas
for ( int i=0 ; i<TotalVal ; ++i )
    { label(Valor[i], (i+1,0), 1.5*S, Formato); }
