//---------------------------------------------------------------
// Fichero:  sectores.asy
// Objetivo: Representar un diagrama de sectores
// Fecha:    M.3.5.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Caracteres Unicode
import unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.5cm);

// Grosor de las líneas
defaultpen(1);

// Los valores
string Valor[]={'Ágata', 'Bruno', 'Celia', 'Diego', 'Elsa'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={45, 20, 30, 15, 10};

// La constante de proporcionalidad
real k=360/sum(Frecuencia);

// El círculo
draw(unitcircle);

// Los sectores
real Angulo=0;
for ( int i=0 ; i<TotalVal ; ++i )
    {
    real Avance=k*Frecuencia[i];
    draw((0,0)--dir(Angulo));
    draw((0,0)--dir(Angulo+Avance));
    label(Valor[i],0.6*dir(Angulo+Avance/2),fontsize(10pt));
    Angulo += Avance;
    }
