//---------------------------------------------------------------
// Fichero:  tetraedro3d.asy
// Objetivo: Mostrar un tetraedro
// Fecha:    D.13.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(5cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// Punto de luz
currentlight=light(10,0,10);

// ---------------------------------------------------------------------------
// Copyright (c) 2008, Jens Schwaiger
// Institut fuer Mathematik, Karl-Franzens-Universitaet
// Heinrichstrasse 36, A-8010 GRAZ, Austria
// Homepage: http://www-ang.kfunigraz.ac.at/~schwaige/

// Version: $Id: polyhedron.asy,v 0.0 2008/02/03 Jens Schwaiger Exp $

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or (at
// your option) any later version.

// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301, USA.

// Modified by Philippe Ivaldi

triple cofgr(guide3 g){ // center of gravity of a closed guide3
  int l=length(g);
  if(l==0) return point(g,0);
  triple cgr=(0,0,0);
  for(int i=0;i<l;++i) cgr=cgr+point(g,i);
  return(1/l)*cgr;
}

path3[] tetrahedron;
guide triangle=polygon(3);
tetrahedron[0]=(point(triangle,0).x,point(triangle,0).y,0);
for(int i=1;i<3;++i) tetrahedron[0]=tetrahedron[0]--(point(triangle,i).x,point(triangle,i).y,0);
tetrahedron[0]=tetrahedron[0]--cycle;
triple sp=(0,0,sqrt(2/3)*abs(point(triangle,1)-point(triangle,0)));
tetrahedron[1]=sp--point(tetrahedron[0],0)--point(tetrahedron[0],1)--cycle;
tetrahedron[2]=sp--point(tetrahedron[0],1)--point(tetrahedron[0],2)--cycle;
tetrahedron[3]=sp--point(tetrahedron[0],2)--point(tetrahedron[0],3)--cycle;
// Adjust data such that the center is the triple (0,0,0) and such that the circumscribed ball has radius 1
triple cotetr; // center of gravity of the tetrahedron
for(int i=0;i<4;++i) cotetr=cotetr+cofgr(tetrahedron[i]);
cotetr=(1/4)*cotetr;
tetrahedron=shift(-cotetr.z*Z)*tetrahedron;
tetrahedron=scale3(1/abs(point(tetrahedron[0],0)))*tetrahedron;
// ---------------------------------------------------------------------------

// Dibujamos las caras
draw(surface(tetrahedron),lightgray+opacity(.7));

// Dibujamos las aristas
draw(tetrahedron,1.5bp+black);
