//---------------------------------------------------------------
// Fichero:  desarrollo.asy
// Objetivo: Representar el desarrollo plano de la pirámide
// Fecha:    D.20.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Un pentágono regular
path Pentagono=rotate(90)*polygon(5);

// El lado del pentágono
real Lado=length(point(Pentagono,0)-point(Pentagono,1));

// La altura de la pirámide
real Altura=2;

// La apotema de pentágono
pair M=(point(Pentagono,0)+point(Pentagono,1))/2;
real ApoPen=length(M);

// La apotema de la pirámide
real ApoPir=sqrt(Altura*Altura+ApoPen*ApoPen);

// El ángulo de cada triángulo en el ápice
real Ang=2*aTan(Lado/(2*ApoPir));

// La base
draw(Pentagono);
label("Base",(0,0),fontsize(16pt));

// Las caras laterales
path Triangulo=(-Lado/2,0)--(Lado/2,0)--(0,ApoPir)--cycle;
Triangulo=shift(M)*rotate(-18)*Triangulo;
pair Apice=point(Triangulo,2);
for (int i=0 ; i<5 ; ++i)
    {
    draw(Triangulo);
    M=(point(Triangulo,0)+point(Triangulo,1))/2;
    pair Vector=Apice-M;
    label(rotate(degrees(Vector))*"Cara lateral",M+0.4*Vector,fontsize(8pt));
    Triangulo=rotate(-Ang,Apice)*Triangulo;
    }
