//---------------------------------------------------------------
// Fichero:  desarrollo.asy
// Objetivo: Representar el desarrollo plano de la pirámide
// Fecha:    M.22.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Caracteres Unicode
import unicode;

// Para markrightangle()
import geometry;

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Un pentágono regular
path Pentagono=polygon(5);

// El lado del pentágono
real Lado=length(point(Pentagono,0)-point(Pentagono,1));

// La altura de la pirámide
real Altura=2;

// La apotema de pentágono
pair M=(point(Pentagono,0)+point(Pentagono,1))/2;
real ApoPen=length(M);

// La apotema de la pirámide
real ApoPir=sqrt(Altura*Altura+ApoPen*ApoPen);

// La separación entre las flechas y el objeto
real Separacion = 0.2;

// Las caras laterales
path Triangulo=(-Lado/2,0)--(Lado/2,0)--(0,ApoPir)--cycle;
for (int i=0 ; i<5 ; ++i)
    {
    M=(point(Triangulo,0)+point(Triangulo,1))/2;
    draw(point(Triangulo,2)--M,1bp+red);
    markrightangle(point(Triangulo,2), M, point(Triangulo,1), 2mm, 0.5bp+red);
    draw(Triangulo);
    label("m",M+0.3*(0,ApoPir)+0.2*E,fontsize(8pt));
    draw((Lado*(i-0.5),-Separacion) -- (Lado*(i+0.5),-Separacion),
         blue, Arrows(HookHead,2bp), Bars(1mm));
    label("Lado", (i*Lado,-2*Separacion), fontsize(8pt));
    Triangulo=shift((Lado,0))*Triangulo;
    }

draw((-Lado/2,-3*Separacion) -- (4.5*Lado,-3*Separacion),
     blue, Arrows(HookHead,2bp), Bars(1mm));
label("Perímetro de la base", (2*Lado,-4*Separacion), fontsize(8pt));
