//---------------------------------------------------------------
// Fichero:  piramide.asy
// Objetivo: Mostrar segmentos una pirámide con sus apotemas
// Fecha:    M.22.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(6cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// Punto de luz
currentlight=light(10,0,10);

// Número de vértices de la base
int N=5;

// La base es un polígono regular
path3 PoligonoBase = path3(rotate(2)*polygon(N));

// El vértice superior
triple V=(0,0,2);

// Las caras del poliedro
path3[] Caras={PoligonoBase};
for (int i=0; i<N; ++i)
    { Caras.push(point(PoligonoBase,i)--point(PoligonoBase,i+1)--V--cycle); }

// Dibujamos las caras
draw(surface(Caras),lightgray+opacity(.5));

// Dibujamos las aristas
draw(Caras,1.5bp+black);

// Las apotemas
for (int i=0; i<N; ++i)
    {
    triple M=(point(PoligonoBase,i)+point(PoligonoBase,i+1))/2;
    draw(V--M,2bp+red);
    dot(M,4bp+black);
    }

// Los puntos
dot(V,4bp+black);

// El texto
pen Formato=Helvetica(series="m",shape="n")+fontsize(6mm)+black;
triple M=(point(PoligonoBase,1)+point(PoligonoBase,2))/2;
label("m",M+0.2*(V-M)/2+0.4*Z+0.25*X,Formato);
