//---------------------------------------------------------------
// Fichero:  cilindro3d-rh.asy
// Objetivo: Mostrar un cilindro con sus dimensiones
// Fecha:    L.11.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4.8cm);

// Punto de proyección
currentprojection=orthographic((5,0,2),Z);

// Datos de la figura plana
real Radio=4, Altura=7;

// La figura plana
path3 Poli=(0,0,0)--(Radio,0,0)--(Radio,0,Altura)--(0,0,Altura);

// El cuerpo de revolución
revolution Cilindro=revolution(Poli,Z);

// Marcamos las bases
skeleton Corte;
Cilindro.transverse(Corte,reltime(Cilindro.g,0.5),P=currentprojection);
draw(shift(Altura/2*Z)*Corte.transverse.front,1bp+black);
draw(shift(-Altura/2*Z)*Corte.transverse.back,1bp+black+linetype("4 4",8));

// Marcamos el contorno
draw(Cilindro.silhouette(),1bp+black);

// Los tres puntos que marcamos
triple T=(0,0,0), A=(0,Radio,0), B=(0,Radio,Altura);
dot(A,3bp+blue);
dot(B,3bp+blue);
dot(T,3bp+blue);

// El radio de la base de abajo
draw(A--T,1bp+blue);
label("$r$",(A+T)/2+0.5*Z,blue);

// La altura
draw(A--B,2bp+blue);
label("$h$",(A+B)/2+0.5*Y,blue);
