//---------------------------------------------------------------
// Fichero:  desarrollo.asy
// Objetivo: Mostrar el desarrollo plano de un cilindro
// Fecha:    S.2.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Datos de la figura plana
real Radio=4, Altura=5;
real Perimetro=2*3.14*Radio;

// Formato de texto
pen Formato=blue+fontsize(12pt);

// La superficie lateral
path Poli=box((0,0),(Perimetro,Altura));
draw(Poli,1bp+black);
real Separacion = 0.2;
draw((Separacion,5*Separacion) -- (Perimetro-Separacion,5*Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));
label("$2·\pi·r$", (Perimetro/2,Altura/2), Formato);
draw((Perimetro+4*Separacion,0) -- (Perimetro+4*Separacion,Altura),
     blue, Arrows(HookHead,5bp), Bars(2mm));
label("$h$", (Perimetro+8*Separacion,Altura/2), Formato);

// Las bases
pair T=(0,0), A=Radio*(Cos(-30),Sin(-30)), M=(T+A)/2;
path Base=circle(T,Radio);
path Segmento=T--A;
pair Vector[] = {(Radio,-Radio),(Perimetro-Radio,Altura+Radio)};
for ( int i=0 ; i<2 ; ++i )
    {
    transform Desplazamiento = shift(Vector[i]);
    draw(Desplazamiento*Base,1bp+black);
    draw(Desplazamiento*Segmento,1bp+blue);
    dot(Desplazamiento*T,3bp+blue);
    dot(Desplazamiento*A,3bp+blue);
    label("$r$", Desplazamiento*M+NNE, Formato);
    }
