//---------------------------------------------------------------
// Fichero:  cono2d-rhg.asy
// Objetivo: Mostrar cómo crear un cono con dimensiones
// Fecha:    X.6.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.8cm);

// Datos de la figura plana
real Radio=4, Altura=5;

// La figura plana
path Poli=(0,0)--(Radio,0)--(0,Altura);
draw(Poli,2bp+black);

// Marcamos el ángulo recto
markrightangle((0,Altura), (0,0), (Radio,0), 4mm, 1bp+blue);

// El eje
real Extra=.4;
draw((0,0)--(0,Altura+Extra), 2bp+black);

// La flecha del giro
path Flecha=(Extra,Altura)..(0,Altura+2*Extra)..(-Extra,Altura);
draw(shift(0,Extra)*Flecha,1bp+blue,ArcArrow(SimpleHead));

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// La flecha que marca el radio
draw((0,-Separacion) -- (Radio,-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// El radio
label("Radio", (Radio/2,-3*Separacion), blue+fontsize(12pt));

// La flecha que marca la altura
draw((-Separacion,0) -- (-Separacion,Altura),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// La altura
label(rotate(90)*"Altura", (-3*Separacion,Altura/2), blue+fontsize(12pt));

// La flecha que marca la generatriz
draw(shift(0.2*Separacion*(Altura,Radio))*((Radio,0) -- (0,Altura)),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// La generatriz
label(rotate(degrees((Radio,-Altura)))*"Generatriz",
      (Radio/2,Altura/2)+0.5*Separacion*(Altura,Radio), blue+fontsize(12pt));
