//---------------------------------------------------------------
// Fichero:  cono3d-rgh.asy
// Objetivo: Mostrar la relación entre los elementos del cono
// Fecha:    X.6.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// cone()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4.8cm);

// Punto de proyección
currentprojection=orthographic((5,4,2),Z);

/////////////////////////////////////////
// https://asy.marris.fr/asymptote/Positions_relatives/index.html
//         #fig_pa01_251211_plan_droite_perpendiculaires
void angledroit(picture pic=currentpicture,
                triple pO, triple pI, triple pJ, real size=.5, pen p=black,
                projection P=currentprojection){
     triple imI=pO+size*unit(pI-pO),
            imJ=pO+size*unit(pJ-pO),
            imK=imI+imJ-pO;
            draw(imI--imK--imJ,p);
}
/////////////////////////////////////////

// Datos de la figura
real Radio=4, Altura=7;

// El cuerpo de revolución
triple T=(0,0,0), V=(0,0,Altura), R=(Radio,0,0);
revolution Cono=cone(T,Radio,Altura,axis=Z,n=2);

// Marcamos la base
skeleton Corte;
Cono.transverse(Corte,reltime(Cono.g,0.5),P=currentprojection);
draw(shift(-Altura*Z)*scale3(2)*Corte.transverse.back,
     1bp+black+linetype("4 4",8));

// Marcamos el contorno
draw(Cono.silhouette(),1bp+black);

// Los tres puntos que marcamos
dot(T,3bp+blue);
dot(V,3bp+blue);
dot(R,3bp+blue);

// El ángulo recto
angledroit(T,V,R,0.5,1bp+blue);

// Formato de texto
pen Formato=fontsize(5mm)+blue;

// La altura
draw(V--T,1.5bp+blue);
label("$h$",(V+T)/2+0.5*Y,Formato);

// La generatriz
draw(V--R,1.5bp+blue);
label("$g$",(V+R)/2-0.5*Y,Formato);

// El radio de la base
draw(T--R,1.5bp+blue);
label("$r$",(T+R)/2+0.75*Y,Formato);
