//---------------------------------------------------------------
// Fichero:  circulos.asy
// Objetivo: Mostrar cuatro círculos
// Fecha:    L.11.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Datos de la figura
real Radio=1;
real Separacion=0.2;

// Formato de texto
pen Formato=blue+fontsize(18pt);

// los círculos
path Circulo=circle((0,0),Radio);
for ( int i=0; i<4 ; ++i )
    {
    draw(shift(i*(2*Radio+Separacion),0)*Circulo,2bp+black);
    label("$\pi·r^2$", (i*(2*Radio+Separacion),0), Formato);
    }
