//---------------------------------------------------------------
// Fichero:  esfera.asy
// Objetivo: Mostrar la esfera
// Fecha:    M.12.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// sphere()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=10;

// Tamaño de la imagen
size(0,3cm);

// Punto de proyección
currentprojection=orthographic((5,0,2),Z);

// Definimos dos puntos
triple T=(0,0,0), A=(0,1,0);

// La esfera
revolution Esfera=sphere(T,1);

// Dibujamos
skeleton Corte;
Esfera.transverse(Corte,reltime(Esfera.g,0.5),P=currentprojection);
draw(Corte.transverse.back,gray+linetype("2 2",8));
draw(Corte.transverse.front,black);
draw(Esfera.silhouette(),1bp+black);

// El radio
draw(A--T,blue);
label("r",(A+T)/2,S,blue);

// Los puntos
dot(T,blue);
dot(A,blue);
