//---------------------------------------------------------------
// Fichero:  solucion04.asy
// Objetivo: Dar la solución 4
// Fecha:    X.14.12.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Dimensiones de los ejes
real Xmin = -6, Xmax = 6, Ymin = -6, Ymax = 6, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de ordenadas
yaxis("y", ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis("x", xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Los puntos
pair A=(-3,4), B=(3,-4);

// Las expansiones
real ExpIzq=0.25, ExpDer=0.25;

// La recta
draw(A+ExpIzq*(A-B) -- B+ExpDer*(B-A));
