//---------------------------------------------------------------
// Fichero:  enunciado.asy
// Objetivo: Dar unos ejes de coordenadas para rellenar
// Fecha:    D.18.12.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Dimensiones de los ejes
real Xmin = -8, Xmax = 8, Ymin = -8, Ymax = 8, Extra = 0.25;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),0.5bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks("%", Step=1, NoZero, Size=0.5mm, pTick=blue);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTicks, above=true);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTicks, above=true);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));
