//---------------------------------------------------------------
// Fichero:  trayectoria.asy
// Objetivo: Mostrar la trayectoria de la bola
// Fecha:    S.22.4.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,1.8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 180, Ymin = 0, Ymax = 25, Extra = 1;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicksX = Ticks("%", Step=10, NoZero, Size=0.5mm, pTick=blue);
ticks FormatoTicksY = Ticks("%", Step=5, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// El eje de ordenadas
yaxis("Altura", ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicksY);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis("Distancia horizontal", xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicksX);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Los puntos
for ( int i=0 ; i<171 ; i+=10 )
  { dot((i,0.5774*i-0.003378*i^2), 3pt+black); }
