//---------------------------------------------------------------
// Fichero:  parabola7.asy
// Objetivo: Representar una parábola
// Fecha:    S.15.4.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// fontsize()
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Dimensiones de los ejes
real Xmin = -7, Xmax = 11, Ymin = -9, Ymax = 7, Extra = 0.5;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),0.3bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=3, step=1, NoZero, Size=0.5mm, size=0.5mm,
                     pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// El eje
pen Punteado = linetype(new real[] {2,2});
draw((2,-9.4) -- (2,7.4), Punteado+blue);

// La gráfica
real F(real x) { return (0.25*x^2-x-8); }
path Grafica=graph(F,-6.1,10.1,n=200);
draw(Grafica);

// El vértice
dot((2,-9),4bp+red);

// Tipo de letra
pen Tipo=Helvetica(series="b",shape="n");

// Las flechas
real Separacion = 0.3;
pen FormatoFlecha=0.5bp+magenta;
pen FormatoEtiqueta=magenta+fontsize(6pt)+Tipo;

draw((-6+Separacion,F(-6)) -- (2-Separacion,F(-6)),
     FormatoFlecha, Arrows(HookHead,3bp), Bars(1mm));
draw((2+Separacion,F(10)) -- (10-Separacion,F(10)),
     FormatoFlecha, Arrows(HookHead,3bp), Bars(1mm));
label("d=8",(-2,F(-6)-1.5*Separacion),FormatoEtiqueta);
label("d=8",(6,F(10)-1.5*Separacion),FormatoEtiqueta);

draw((-2+Separacion,F(-2)) -- (2-Separacion,F(-2)),
     FormatoFlecha, Arrows(HookHead,3bp), Bars(1mm));
draw((2+Separacion,F(6)) -- (6-Separacion,F(6)),
     FormatoFlecha, Arrows(HookHead,3bp), Bars(1mm));
label("d=4",(0,F(-2)+1.5*Separacion),FormatoEtiqueta);
label("d=4",(4,F(6)+1.5*Separacion),FormatoEtiqueta);

// Los puntos simétricos
pen FormatoPunto=3bp+magenta;
int Abs[]={-6,10,-4,8,-2,6,0,4};
string Nombre="ABCDEFGH";
pair Pos[]={SW,SE,SW,SE,SW,SE,SW,SE};
for ( int i=0 ; i<Abs.length ; ++i )
  {
  pair V=(Abs[i],F(Abs[i]));
  label(substr(Nombre,i,1),V,Pos[i],Tipo+fontsize(6pt)+black);
  dot(V,FormatoPunto);
  }
