//---------------------------------------------------------------
// Fichero:  nombres.asy
// Objetivo: Mostrar los nombres usados
// Fecha:    J.20.4.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// La recta
draw((0.75,0)--(4.5,0));

// El rectángulo
filldraw(box((1,0),(4,1.5)),lightgray);

// Las flechas
real Separacion = 0.2;
pen FormatoFlecha=0.5bp+deepgreen;
draw((1,-Separacion) -- (4,-Separacion),
     FormatoFlecha, Arrows(HookHead,3bp), Bars(1mm));
draw((4+Separacion,Separacion/4) -- (4+Separacion,1.5),
     FormatoFlecha, Arrows(HookHead,3bp), Bars(1mm));

// Los nombres
pen FormatoEtiqueta=blue+fontsize(10pt)+Bookman(series="m",shape="n");
label("x",(2.5,-2*Separacion),FormatoEtiqueta);
label("y",(4+2*Separacion,0.75),FormatoEtiqueta);
label("A",(2.5,0.75),FormatoEtiqueta);
