//---------------------------------------------------------------
// Fichero:  funcionF.asy
// Objetivo: Representar la función F
// Fecha:    V.17.2.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis(), graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.5cm);

// Dimensiones de los ejes
real Xmin = -6, Xmax = 6, Ymin = -3, Ymax = 3, Extra = 0.25;

// La letra del problema
label("F",(Xmin,Ymax),NW);

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),0.3bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
real F(real x) { return (x^2); }
path Grafica=graph(F,-1,1,n=400);
draw(shift(3,-3)*Grafica);
draw(scale(-1)*shift(3,-3)*Grafica);
draw((-6,2)--(-4,2));
draw((-2,2)--(2,-2));
draw((4,-2)--(6,-2));
