//---------------------------------------------------------------
// Fichero:  funcionB.asy
// Objetivo: Representar la función B
// Fecha:    V.24.2.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 36.5, Ymin = 0, Ymax = 12, Extra = 0.25;

// La letra del problema
label("B",(Xmin,Ymax),5*W);

// Rejilla de ayuda
add(scale(3)*grid(12,4,0.3bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los ejes
string Multiplica10(real x) { return string(10*x); }
ticks FormatoTicksX = Ticks(ticklabel=Multiplica10,
                            Step=3, Size=0.5mm, step=1, size=0.25mm,
                            NoZero, pTick=blue);
string Multiplica2(real x) { return string(2*x); }
ticks FormatoTicksY = Ticks(ticklabel=Multiplica2,
                            Step=3, Size=0.5mm, step=1, size=0.25mm,
                            NoZero, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicksY);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicksX);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// Las horas de luz
// Orden: ./luz.py -54.5 >funcionB.txt
file Dato=input("funcionB.txt");
real[] Luz=Dato;

// La gráfica
guide Grafica;
for (int i=0 ; i<Luz.length ; ++i)
    { Grafica = Grafica -- (i/10,Luz[i]/2); }
draw(Grafica);
