//---------------------------------------------------------------
// Fichero:  graficaV.asy
// Objetivo: Representar la gráfica V
// Fecha:    D.26.2.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 125, Ymin = 0, Ymax = 50, Extra = 1;

// La letra del problema
label("V",(Xmin,Ymax),3W+S);

// Rejilla de ayuda
add(scale(5)*grid(25,10,0.3bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los ejes
ticks FormatoTicksX = Ticks(Step=25, Size=0.5mm, step=5, size=0.25mm,
                            NoZero, pTick=blue);
ticks FormatoTicksY = Ticks(Step=10, Size=0.25mm, step=5, size=0.25mm,
                            NoZero, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicksY);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicksX);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
draw((0,0)--(Xmax/2,Ymax/4)--(Xmax,Ymax));
