//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Mostrar el ejemplo 1
// Fecha:    D.12.2.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.5cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 5, Ymin = 0, Ymax = 2, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// El eje de abscisas
label("Tiempo",(Xmax,Ymin),2*SW,blue+fontsize(8pt));
draw((Xmin-Extra,0) -- (Xmax+Extra,0),heavygray);

// El eje de ordenadas
label(rotate(90)*"Velocidad",(Xmin,Ymax),2*SW,blue+fontsize(8pt));
draw((0,Ymin-Extra) -- (0,Ymax+Extra),heavygray);

// Dos puntos de la gráfica
pair A=(0.5,2), B=(5,1);

// La gráfica
draw(A -- B);

// Un punto de la gráfica
dot(A+0.35*(B-A),red+3pt);
