//---------------------------------------------------------------
// Fichero:  maximorelativo.asy
// Objetivo: Representar una función con un máximo relativo
// Fecha:    L.13.2.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis(), graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -6, Xmax = 6, Ymin = -2, Ymax = 2, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
real F(real x) { return (1.5*(-x^2+2*x)); }
path Grafica=graph(F,0,2,n=400);
draw(Grafica);
draw((-6,-2) .. controls (-5,-2) and (-2,-2) ..  (0,0));
draw((2,0) .. controls (3,0) and (5,1) .. (6,2));

// Un punto de la gráfica
dot((1,1.5),red+3pt);
