//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Mostrar el ejemplo 2
// Fecha:    V.10.3.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Dimensiones de los ejes
real Xmin = -1, Xmax = 8, Ymin = -1, Ymax = 7, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
pair A=(1,2), B=(7,6);
pair V=B-A;
draw(A+1.2*V -- B-1.3*V);

// Los incrementos
pair C=(7,2);
draw(A -- C -- B,heavygreen);

// Dos puntos
dot(Label("A",fontsize(12pt)+black),A,NW,3pt+red);
dot(Label("B",fontsize(12pt)+black),B,NW,3pt+red);

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// Las flechas que marcan los incrementos
draw(A-(0,Separacion) -- C-(0,Separacion),
     0.75bp+blue, Arrow(HookHead,5bp), Bars(1.5mm));
draw(C+(Separacion,0) -- B+(Separacion,0),
     0.75bp+blue, Arrow(HookHead,5bp), Bars(1.5mm));

// Los valores
label("6", (A+C)/2-(0,2*Separacion), fontsize(8pt));
label("4", (C+B)/2+(2*Separacion,0), fontsize(8pt));
