//---------------------------------------------------------------
// Fichero:  relacion.asy
// Objetivo: Mostrar la relacion entre los incrementos
// Fecha:    V.10.3.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 6, Ymin = 0, Ymax = 3.25, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// El eje de ordenadas
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
pair A=(1,1), B=(5,3);
pair V=B-A;
draw(A+1.2*V -- B-1.3*V);

// Los incrementos
pair C=(5,1);
draw(A -- C -- B,heavygreen);

// Dos puntos
dot(A,3pt+red);
dot(B,3pt+red);

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// Las flechas que marcan los incrementos
draw(A-(0,Separacion) -- C-(0,Separacion),
     0.75bp+blue, Arrow(HookHead,5bp), Bars(1.5mm));
draw(C+(Separacion,0) -- B+(Separacion,0),
     0.75bp+blue, Arrow(HookHead,5bp), Bars(1.5mm));

// Los valores
label("$\Delta x$", (A+C)/2-(0,2*Separacion), fontsize(8pt));
label("$\Delta y$", (C+B)/2+(2*Separacion,0), fontsize(8pt));
