//---------------------------------------------------------------
// Fichero:  paso3.asy
// Objetivo: Mostrar el paso 3 de la explicación
// Fecha:    L.20.3.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Dimensiones de los ejes
real Xmin = -7, Xmax = 7, Ymin = -6, Ymax = 5, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los ejes
ticks FormatoTicksX = Ticks(Label(align=W),Step=1, NoZero, Size=0.5mm, pTick=blue);
ticks FormatoTicksY = Ticks(Label(align=E),Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicksY);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicksX);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
draw((-7,-5.75)--(7,4.75));

// Dos puntos
pair A=(-2,-2), B=(6,4);
dot(A,3pt+red);
dot(B,3pt+red);

// La flecha que sale de y=-5
draw((-0.3,-5) -- (-5.7,-5), deepgreen, Arrow(HookHead,1.5bp));

// El punto
dot((-6,-5),deepgreen+3pt);

// La flecha que llega a x=-6
draw((-6,-4.7) -- (-6,-0.3), deepgreen, Arrow(HookHead,1.5bp));
