//---------------------------------------------------------------
// Fichero:  koch.asy
// Objetivo: Mostrar una sucesión de figuras de Koch
// Fecha:    V.9.9.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

//---------------------------------------------------------------
// Obtenido de https://tex.stackexchange.com/questions/562331/infinite-triangles-koch-snowflakes-and-combining-into-one-line
// Autor: https://tex.stackexchange.com/users/27243/g-kov
// Licencia: https://tex.stackexchange.com/help/licensing
// Ligeras adaptaciones de Pedro Reina

guide gKoch(int n, pair A, pair B)
    {
    guide g;
    pair C,D,E;

    if(n>0)
        {
        C=A+(B-A)/3;
        E=B+(A-B)/3;
        D=rotate(-60,C)*E;
        g=gKoch(n-1,A,C)--gKoch(n-1,C,D)--gKoch(n-1,D,E)--gKoch(n-1,E,B);
        }
    else
       { g=A--B;}

    return g;
    }

guide KochFlake(int n, pair A, pair B, pair C)
    { return gKoch(n,A,B)--gKoch(n,B,C)--gKoch(n,C,A)--cycle; }

pen linePen=black+0.8bp;
pair A,B,C,D;
real a=1;
A=(0,a); D=(0,-a); B=rotate(120)*A; C=rotate(-120)*A;
transform sh=identity();

for (int i=0 ;i<4 ;++i)
    {
    draw(sh*KochFlake(i,A,B,C),linePen);
    label("Figura " + string(i+1),sh*D,plain.S);
    sh*=shift(2.6*a,0);
    }
