//---------------------------------------------------------------
// Fichero:  ruleta.asy
// Objetivo: Representar una ruleta
// Fecha:    M.14.6.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm,0cm);

// Formato de los textos
pen FormatoTexto=Helvetica(series="m",shape="n")+fontsize(20pt);

// Formato de las líneas
pen FormatoLinea=1pt+blue;

// Los colores de los números (0 es negro, 1 es rojo, 2 es solo para el 0)
int[] Color={2, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1,
             0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1};

// Escribimos los números
for ( int i=1 ; i<37 ; ++i )
    {
    // Averiguamos con qué color escribirlo
    pen ColorTexto;
    if (Color[i]>0)
        { ColorTexto=red; }
    else
        { ColorTexto=black; }

    // Averiguamos en qué posición escribirlo
    int Col=-3*(int)((i-1)/3);
    int Fil=3*((i-1)%3);

    // Lo escribimos
    label(string(i), (Fil,Col), FormatoTexto+ColorTexto);

    // Lo rodeamos de un cuadrado
    draw(box((Fil-1.5,Col-1.5),(Fil+1.5,Col+1.5)),FormatoLinea);
    }

// Escribimos el cero
label("0", (3,3), FormatoTexto+heavygreen);
draw(box((-1.5,1.5),(7.5,4.5)),FormatoLinea);
