//---------------------------------------------------------------
// Fichero:  baloncesto.asy
// Objetivo: Dibujar el diagrama de caja y bigotes del baloncesto
// Fecha:    L.11.12.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// fontsize()
import fontsize;

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Los valores estadísticos
real Md=9.25, Q1=8.2, Q3=12.95, LI=2.8, LS=18;

// Los valores visuales
real Ancho=2, Sep=0.2;

// La caja
draw(box((Q1,0),(Q3,Ancho)));

// La mediana
draw((Md,0)--(Md,Ancho));

// Bigote izquierdo
draw((LI,Ancho/2)--(Q1,Ancho/2));
draw((LI,Ancho/2+Sep)--(LI,Ancho/2-Sep));

// Bigote derecho
draw((Q3,Ancho/2)--(LS,Ancho/2));
draw((LS,Ancho/2+Sep)--(LS,Ancho/2-Sep));

// La escala
draw((3,-1) -- (18,-1), blue);
pen Formato=fontsize(10pt)+blue;
for ( int i=3 ; i<19 ; ++i )
    {
    draw((i,-1+Sep/2) -- (i,-1-Sep/2), blue);
    label(string(i),(i,-1-Sep),S,Formato);
    }
