//---------------------------------------------------------------
// Fichero:  theriver.asy
// Objetivo: Dibujar el diagrama de caja y bigotes de The River
// Fecha:    M.12.12.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// fontsize()
import fontsize;

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena mm:ss
string MMSS(int s)
    {
    string Min=string(quotient(s,60));
    string Seg=string(s%60);
        if ( Seg=='0' )  { Seg='00';}
    return Min+':'+Seg;
    }

// Los valores estadísticos
real Md=234.5, Q1=196, Q3=289, LI=160, LS=428.5;

// Los valores visuales
real Ancho=30, Sep=3;

// La caja
draw(box((Q1,0),(Q3,Ancho)));

// La mediana
draw((Md,0)--(Md,Ancho));

// Bigote izquierdo
draw((LI,Ancho/2)--(Q1,Ancho/2));
draw((LI,Ancho/2+Sep)--(LI,Ancho/2-Sep));

// Bigote derecho
draw((Q3,Ancho/2)--(LS,Ancho/2));
draw((LS,Ancho/2+Sep)--(LS,Ancho/2-Sep));

// Valores atípicos
path Hex=shift(0,Ancho/2)*scale(2)*polygon(6);
filldraw(shift(514,0)*Hex);

// La escala
real Ord=-8;
draw((160,Ord) -- (520,Ord), blue);
pen Formato=fontsize(10pt)+blue;
for ( int i=160 ; i<521 ; i+=20 )
    {
    draw((i,Ord+Sep/2) -- (i,Ord-Sep/2), blue);
    label(MMSS(i),(i,Ord-Sep),S,Formato);
    }
