#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  prepara.py
# Objetivo: Prepara un ejercicio de datos por intervalos
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    M.7.11.2023
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

from numpy import random

#------------------------------------------------
# Constantes
#------------------------------------------------

# El número de datos
Num = 39

# La media
Media = 163.4

# La desviación típica
Desviacion = 7.1

#------------------------------------------------
# El programa
#------------------------------------------------

# La lista de datos elegidos
Lista = []

# Queremos obtener Num datos
while len(Lista)<Num:

    # Obtenemos un valor aleatorio según una normal
    Valor = random.normal(loc=Media, scale=Desviacion)

    # Vemos si está más cerca de tres sigmas
    if Valor>Media-3*Desviacion and Valor<Media+3*Desviacion:
        # Lo redondeamos a un decimal
        Valor = round(Valor,1)
        # Lo imprimimos
        print(Valor),
        # Lo guardamos
        Lista.append(Valor)

# La media
print '\nMedia:', sum(Lista)/Num

# Ordenamos los datos de menor a mayor y los imprimimos:
Lista.sort()
for i in range(Num):
    print Lista[i],
