#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  prepara.py
# Objetivo: Prepara un ejercicio de datos por intervalos
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    M.7.11.2023
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# random.normal(), random.random()
from numpy import random

#------------------------------------------------
# Constantes
#------------------------------------------------

# El número de datos
Num = 45

# La media
Media = 175

# La desviación típica
Desviacion = 15

# Valores límite
Menor=155
Mayor=196

#------------------------------------------------
# El programa
#------------------------------------------------

# La lista de datos elegidos
Lista = []

# Queremos obtener Num datos
while len(Lista)<Num:

    # Obtenemos un valor aleatorio según una normal
    Valor = random.normal(loc=Media, scale=Desviacion)

    # Vemos si está en el rango
    if Valor>=Menor and Valor<=Mayor:
        # Lo redondeamos sin decimales
        Valor = int(round(Valor,0))
        # Para sesgar un poco, no admitimos algunos valores
        Vale = True
        if Valor>Media and random.random()>0.25: Vale = False
        if Vale:
            # Lo imprimimos
            print(Valor),
            # Lo guardamos
            Lista.append(Valor)

# La media
print '\nMedia:', sum(Lista)/float(Num)

# Ordenamos los datos de menor a mayor y los imprimimos:
Lista.sort()
for i in range(Num):
    print Lista[i],
