//---------------------------------------------------------------
// Fichero:  paso2.asy
// Objetivo: Representar el paso 2
// Fecha:    X.8.11.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm,4.5cm);

// Grosor de las líneas
defaultpen(1);

// Los formatos de texto
pen FormatoSi=black+fontsize(8pt);
pen FormatoNo=white+fontsize(8pt);

// Los valores de los extremos de los intervalos
string Valor[]={'1', '2', '3', '4', '5', '6'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={4, 10, 7, 5, 2};
int MaxFre=max(Frecuencia);

// Escala para modificar las frecuencias
real Escala=0.5;

// Los ejes
draw((0,0)--(TotalVal+.5,0));
draw((0,0)--(0,Escala*(MaxFre+.5)));

// El eje de ordenadas
for ( int i=1 ; i<=MaxFre ; ++i )
    { label(string(i), (0,Escala*i), 2*W, FormatoNo); }

// El eje de absisas
for ( int i=0 ; i<TotalVal ; ++i )
    {
    label(Valor[i], (i+1,0), 1.5*S, FormatoSi);
    draw((i+1,-0.05)--(i+1,0.05));
    }
