//---------------------------------------------------------------
// Fichero:  analisis1.asy
// Objetivo: Representar el análisis 1
// Fecha:    S.11.11.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Gaussrand()
include stats;

// Tamaño de la imagen
size(4cm);

// El radio de la diana
int R=5;

// Un punto cualquiera
pair P;

// Función que devuelve un punto dentro de la diana
pair Disparo()
    {
    bool Sigue = true;
    while ( Sigue )
        {
        real Lejania=1.25;
        P=(Lejania*Gaussrand(),Lejania*Gaussrand());
        if ( length(P)<R )  { Sigue = false; }
        }
    return P;
    }

// La diana
draw(scale(R)*unitcircle, 0.75bp+gray);

// Iniciamos el generador de números aleatorios
srand(6);

// Obtenemos 10 disparos
pair[] Rafaga;
pair Medio=(0,0);
for ( int i=0 ; i<10 ; ++i )
    {
    P=Disparo();
    Rafaga[i]=P;
    Medio += P;
    }

// El punto medio
Medio /= 10;

// Dibujamos disparos, líneas y punto medio
pen FormatoPunto=2bp+blue;
pen FormatoLinea=1bp+green;
for ( int i=0 ; i<10 ; ++i )
    {
    P=Rafaga[i];
    draw(P -- Medio, FormatoLinea);
    dot(P,FormatoPunto);
    }
dot(Medio,3bp+red);
