//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Mostrar un ejemplo de diagrama de caja y bigotes
// Fecha:    S.9.12.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// fontsize()
import fontsize;

// Tamaño de la imagen
size(0,2cm);

// Grosor de las líneas
defaultpen(1);

// Los valores estadísticos
real RIC=6, Mn=-4, Mx=8.5, Md=2;

// Los valores visuales
real Ancho=2, Sep=0.2;

// La caja
draw(box((0,0),(RIC,Ancho)));

// La mediana
draw((Md,0)--(Md,Ancho));

// Bigote izquierdo
draw((Mn,Ancho/2)--(0,Ancho/2));
draw((Mn,Ancho/2+Sep)--(Mn,Ancho/2-Sep));

// Bigote derecho
draw((RIC,Ancho/2)--(Mx,Ancho/2));
draw((Mx,Ancho/2+Sep)--(Mx,Ancho/2-Sep));

// Los textos
pen Formato=fontsize(10pt)+blue;
label("$Mn$",(Mn,-1),S,Formato);
label("$Q_1$",(0,-1),S,Formato);
label("$Md$",(Md,-1),S,Formato);
label("$Q_3$",(RIC,-1),S,Formato);
label("$Mx$",(Mx,-1),S,Formato);

// Las flechas
draw((Mn,-1)--(Mn,0.6), deepgreen, Arrow(5bp));
draw((0,-1)--(0,-0.2), deepgreen, Arrow(5bp));
draw((Md,-1)--(Md,-0.2), deepgreen, Arrow(5bp));
draw((RIC,-1)--(RIC,-0.2), deepgreen, Arrow(5bp));
draw((Mx,-1)--(Mx,0.6), deepgreen, Arrow(5bp));
