//---------------------------------------------------------------
// Fichero:  funcion.asy
// Objetivo: Representar el polígono de porcentajes acumulados
//           y uno de sus trozos
// Fecha:    J.14.12.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// fontsize()
import fontsize;

// Tamaño de la imagen
size(5.6cm);

// Grosor de las líneas
defaultpen(1);

// Los valores de los extremos de los intervalos
string Valor[]={'130', '140', '150', '160', '170', '180', '190'};
int TotalVal = Valor.length;

// Las frecuencias absolutas acumuladas
int Frecuencia[]={0,48,132,303,446,575,660};
int MaxFre=max(Frecuencia);
int TotalFre = Frecuencia.length;

// Escala para modificar los porcentajes
real Escala=0.007;

// Los ejes
draw((0,0)--(TotalVal+.5,0));
draw((0,0)--(0,Escala*(MaxFre+.5)));

// Formatos
pen FormatoTexto=blue+fontsize(6pt);
pen FormatoPunto=red+2bp;
pen FormatoSegmento=gray+0.5bp;

// El eje de ordenadas
for ( int i=0 ; i<TotalFre ; ++i )
    {
    int Valor=Frecuencia[i];
    label(string(Valor), (0,Escala*Valor), 2*W, FormatoTexto);
    draw((-0.05,Escala*Valor)--(0.05,Escala*Valor));
    }

// La marca de que cortamos un trozo de eje de abscisas
fill(box((0.4,-0.1),(0.6,0.1)),white);
draw((0.35,-0.1)--(0.45,0.1));
draw((0.55,-0.1)--(0.65,0.1));

// Los segmentos
for ( int i=1 ; i<TotalVal ; ++i )
    {
    draw((i+1,0)--(i+1,Escala*Frecuencia[i]),FormatoSegmento);
    draw((i,Escala*Frecuencia[i-1])--(i+1,Escala*Frecuencia[i]));
    }

// El eje de absisas
for ( int i=0 ; i<TotalVal ; ++i )
    {
    label(Valor[i], (i+1,0), 1.5*S, FormatoTexto);
    draw((i+1,-0.05)--(i+1,0.05));
    }

// El segmento que nos interesa
draw((3,Escala*Frecuencia[2])--(4,Escala*Frecuencia[3]), heavygreen+2bp);

// Los puntos
for ( int i=1 ; i<=TotalVal ; ++i )
    { dot((i,Escala*Frecuencia[i-1]), FormatoPunto); }
