//---------------------------------------------------------------
// Fichero:  figura.asy
// Objetivo: Representar el polígono de frecuancias acumuladas
// Fecha:    D.17.12.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// fontsize()
import fontsize;

// Tamaño de la imagen
size(12cm);

// Grosor de las líneas
defaultpen(2);

// Los valores de los extremos de los intervalos
string Valor[]={'8', '12', '16', '20', '24', '28', '32', '36'};
int TotalVal = Valor.length;

// Las frecuencias absolutas acumuladas
int Frecuencia[]={0,102,221,376,523,800,1102,1250};
int MaxFre=max(Frecuencia);
int TotalFre = Frecuencia.length;

// Escala para modificar los porcentajes
real Escala=0.0032;

// Los ejes
draw((0,0)--(TotalVal+.5,0));
draw((0,0)--(0,Escala*(MaxFre+.5)));

// Formatos
pen FormatoTexto=blue+fontsize(12pt);
pen FormatoPunto=red+4bp;

// El eje de ordenadas
for ( int i=0 ; i<TotalFre ; ++i )
    {
    int Valor=Frecuencia[i];
    label(string(Valor), (0,Escala*Valor), 2*W, FormatoTexto);
    draw((-0.05,Escala*Valor)--(0.05,Escala*Valor));
    }

// La marca de que cortamos un trozo de eje de abscisas
fill(box((0.4,-0.1),(0.6,0.1)),white);
draw((0.35,-0.1)--(0.45,0.1));
draw((0.55,-0.1)--(0.65,0.1));

// Los segmentos
for ( int i=1 ; i<TotalVal ; ++i )
    { draw((i,Escala*Frecuencia[i-1])--(i+1,Escala*Frecuencia[i])); }

// El eje de absisas
for ( int i=0 ; i<TotalVal ; ++i )
    {
    label(Valor[i], (i+1,0), 1.5*S, FormatoTexto);
    draw((i+1,-0.05)--(i+1,0.05));
    }

// Los puntos
for ( int i=1 ; i<=TotalVal ; ++i )
    { dot((i,Escala*Frecuencia[i-1]), FormatoPunto); }

// Dos flechas y un punto
real V=Escala*800, X=6;
dot((X,V),deepmagenta+6bp);
draw((0.2,V) -- (X-0.2,V), magenta+1.5bp, Arrow(HookHead,4bp));
draw((X,V-0.2) -- (X,0.2), magenta+1.5bp, Arrow(HookHead,4bp));

// Dos flechas y un punto
real V=Escala*376, X=4;
dot((X,V),deepmagenta+6bp);
draw((X-0.2,V) -- (0.2,V), magenta+1.5bp, Arrow(HookHead,4bp));
draw((X,0.2) -- (X,V-0.2), magenta+1.5bp, Arrow(HookHead,4bp));
