//---------------------------------------------------------------
// Fichero:  cuadrilatero2.asy
// Objetivo: Dibujar un cuadrilátero
// Fecha:    X.10.5.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(60,0), C=(60,25), D=(9.6,37.8);

// El cuadrilátero
draw(A -- B -- C -- D -- A);

// Los nombres de los vértices
pen FormatoTexto=fontsize(8pt)+Helvetica(series="m",shape="n");
label("E", A, W, black+FormatoTexto);
label("F", B, E, black+FormatoTexto);
label("G", C, NE, black+FormatoTexto);
label("H", D, N, black+FormatoTexto);

// Las dimensiones
label("60", (A+B)/2, S, black+FormatoTexto);
label("25", (C+B)/2, E, black+FormatoTexto);
label("52", (C+D)/2, N, black+FormatoTexto);
label("39", (A+D)/2, W, black+FormatoTexto);

// Marcamos un ángulo recto
markrightangle(A, B, C, 3mm, 0.4bp+black);
