#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  cono.py
# Objetivo: Da el área y el volumen de un cono a partir de dos datos
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    S.20.5.2023
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

# sqrt(), pi
import math

#------------------------------------------------
# Funciones
#------------------------------------------------

#------------------------------------------------
# Calcula la hipotenusa a partir de los catetos
def Hipotenusa(b,c):
    return math.sqrt(b**2+c**2)

#------------------------------------------------
# Calcula un cateto a partir de la hipotenusa y el otro cateto
def Cateto(a,b):
    return math.sqrt(a**2-b**2)

#------------------------------------------------
# El programa
#------------------------------------------------

# Las tres dimensiones del cono
Altura = 0
Radio = 0
Generatriz = 0

# Leemos los datos de la línea de órdenes
for i in range(len(sys.argv)):
    if sys.argv[i] == 'h':
        Altura = float(sys.argv[i+1])
    if sys.argv[i] == 'r':
        Radio = float(sys.argv[i+1])
    if sys.argv[i] == 'g':
        Generatriz = float(sys.argv[i+1])

# Mostramos los datos y calculamos el que falta
if Altura == 0:
    print 'Radio:', Radio
    print 'Generatriz:', Generatriz
    Altura = Cateto(Generatriz,Radio)
if Radio == 0:
    print 'Altura:', Altura
    print 'Generatriz:', Generatriz
    Radio = Cateto(Generatriz,Altura)
if Generatriz == 0:
    print 'Altura:', Altura
    print 'Radio:', Radio
    Generatriz = Hipotenusa(Altura,Radio)

# El área de la base
AreaBase = math.pi*Radio**2

# El área total
Area = AreaBase + math.pi*Radio*Generatriz

# El volumen
Volumen = AreaBase*Altura/3

# Mostramos el resultado
print 'Área:', Area
print 'Volumen:', Volumen
