//---------------------------------------------------------------
// Fichero:  tortuga.asy
// Objetivo: Representar cómo se construye la tortuga
// Fecha:    J.11.5.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Función que dibuja lados y apotemas de un hexágono
void DibujaHexagono(path H)
    {
    for ( int i=0 ; i<3 ; ++i )
        {
        // Las apotemas
        pen Apotema=0.75bp+mediumblue;
        draw(((point(H,i)+point(H,i+1))/2)--((point(H,i+3)+point(H,i+4))/2),
             Apotema);
        // Los lados
        pen Lado=1.5bp+mediumred;
        draw(point(H,i)--point(H,i+1), Lado);
        draw(point(H,i+3)--point(H,i+4), Lado);
        }
    }

// El hexágono de la izquierda
path H1=polygon(6);

// El hexágono del centro, arriba
path H2=shift(1.5,1*sqrt(3)/2)*H1;

// El hexágono del centro, abajo
path H3=shift(1.5,-1*sqrt(3)/2)*H1;

// El hexágono de la derecha
path H4=shift(3,0)*H1;

// Dibujamos los hexágonos
DibujaHexagono(H1);
DibujaHexagono(H2);
DibujaHexagono(H3);
DibujaHexagono(H4);

// Los trece vértices de la tortuga
pair V[];
V[0] = (point(H2,0)+point(H2,3))/2;
V[1] = (point(H1,1)+point(H1,2))/2;
V[2] = point(H1,2);
V[3] = (point(H1,2)+point(H1,3))/2;
V[4] = (point(H1,0)+point(H1,3))/2;
V[5] = (point(H1,0)+point(H1,1))/2;
V[6] = point(H1,0);
V[7] = (point(H3,4)+point(H3,5))/2;
V[8] = (point(H3,0)+point(H3,3))/2;
V[9] = (point(H3,0)+point(H3,1))/2;
V[10] = point(H3,1);
V[11] = (point(H4,5)+point(H4,0))/2;
V[12] = (point(H4,0)+point(H4,3))/2;

// Construimos y dibujamos la tortuga
guide Tortuga;
for ( int i=0 ; i<13 ; ++i )
    { Tortuga = Tortuga -- V[i]; }
Tortuga = Tortuga -- cycle;
draw(Tortuga, 2.5bp+black);
