//---------------------------------------------------------------
// Fichero:  trapecio.asy
// Objetivo: Dibujar un trapecio isósceles inscrito en una circunferencia
// Fecha:    V.12.5.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// Datos del trapecio
real BaseMayor=66;
real BaseMenor=24;
real Lado=29;

// Calculamos las semibases
real SemiBaseMayor=BaseMayor/2;
real SemiBaseMenor=BaseMenor/2;

// Calculamos la altura del trapecio
real Aux=(BaseMayor-BaseMenor)/2;
real Altura=sqrt(Lado*Lado-Aux*Aux);

// Calculamos la distancia entre la base mayor y el centro
real Distancia=(SemiBaseMayor*SemiBaseMayor-SemiBaseMenor*SemiBaseMenor-
                Altura*Altura)/(2*Altura);

// Calculamos el radio de la circunferencia circunscrita
real Radio=sqrt(Distancia*Distancia+SemiBaseMayor*SemiBaseMayor);

// La circunferencia y un punto
draw(circle((0,0),Radio));
pair T=Radio*dir(35);

// Los vértices del trapecio
pair A=(-SemiBaseMayor,-Distancia);
pair B=(SemiBaseMayor,-Distancia);
pair C=(SemiBaseMenor,-Distancia-Altura);
pair D=(-SemiBaseMenor,-Distancia-Altura);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// Un radio
draw((0,0) -- T,red);

// Los puntos
pen FormatoPunto=3bp+blue;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(D,FormatoPunto);
dot((0,0),FormatoPunto);
dot(T,FormatoPunto);

// Los textos
pen FormatoTexto=fontsize(8pt)+Helvetica(series="b",shape="n");
label(string(BaseMayor), (A+B)/2, N, deepgreen+FormatoTexto);
label(string(BaseMenor), (C+D)/2, N, deepgreen+FormatoTexto);
label(string(Lado), (A+D)/2, 0.3NE, deepgreen+FormatoTexto);
label(string(Lado), (B+C)/2, 0.3NW, deepgreen+FormatoTexto);
label("?", T/2, NW, red+FormatoTexto);
